package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  Account,
  Region,
  ExecutionRoleName,
  MaxConcurrency,
  MaxErrors
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TargetLocation(
    accounts: Optional[Iterable[Account]] = Optional.Absent,
    regions: Optional[Iterable[Region]] = Optional.Absent,
    targetLocationMaxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    targetLocationMaxErrors: Optional[MaxErrors] = Optional.Absent,
    executionRoleName: Optional[ExecutionRoleName] = Optional.Absent,
    targetLocationAlarmConfiguration: Optional[
      zio.aws.ssm.model.AlarmConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.TargetLocation = {
    import TargetLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.TargetLocation
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            Account.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(
        targetLocationMaxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.targetLocationMaxConcurrency)
      .optionallyWith(
        targetLocationMaxErrors.map(value =>
          MaxErrors.unwrap(value): java.lang.String
        )
      )(_.targetLocationMaxErrors)
      .optionallyWith(
        executionRoleName.map(value =>
          ExecutionRoleName.unwrap(value): java.lang.String
        )
      )(_.executionRoleName)
      .optionallyWith(
        targetLocationAlarmConfiguration.map(value => value.buildAwsValue())
      )(_.targetLocationAlarmConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.TargetLocation.ReadOnly =
    zio.aws.ssm.model.TargetLocation.wrap(buildAwsValue())
}
object TargetLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.TargetLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.TargetLocation =
      zio.aws.ssm.model.TargetLocation(
        accounts.map(value => value),
        regions.map(value => value),
        targetLocationMaxConcurrency.map(value => value),
        targetLocationMaxErrors.map(value => value),
        executionRoleName.map(value => value),
        targetLocationAlarmConfiguration.map(value => value.asEditable)
      )
    def accounts: Optional[List[Account]]
    def regions: Optional[List[Region]]
    def targetLocationMaxConcurrency: Optional[MaxConcurrency]
    def targetLocationMaxErrors: Optional[MaxErrors]
    def executionRoleName: Optional[ExecutionRoleName]
    def targetLocationAlarmConfiguration
        : Optional[zio.aws.ssm.model.AlarmConfiguration.ReadOnly]
    def getAccounts: ZIO[Any, AwsError, List[Account]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regions", regions)
    def getTargetLocationMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField(
        "targetLocationMaxConcurrency",
        targetLocationMaxConcurrency
      )
    def getTargetLocationMaxErrors: ZIO[Any, AwsError, MaxErrors] = AwsError
      .unwrapOptionField("targetLocationMaxErrors", targetLocationMaxErrors)
    def getExecutionRoleName: ZIO[Any, AwsError, ExecutionRoleName] =
      AwsError.unwrapOptionField("executionRoleName", executionRoleName)
    def getTargetLocationAlarmConfiguration
        : ZIO[Any, AwsError, zio.aws.ssm.model.AlarmConfiguration.ReadOnly] =
      AwsError.unwrapOptionField(
        "targetLocationAlarmConfiguration",
        targetLocationAlarmConfiguration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.TargetLocation
  ) extends zio.aws.ssm.model.TargetLocation.ReadOnly {
    override val accounts: Optional[List[Account]] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.Account(item)
        }.toList
      )
    override val regions: Optional[List[Region]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.Region(item)
        }.toList
      )
    override val targetLocationMaxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocationMaxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val targetLocationMaxErrors: Optional[MaxErrors] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocationMaxErrors())
        .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val executionRoleName: Optional[ExecutionRoleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleName())
        .map(value => zio.aws.ssm.model.primitives.ExecutionRoleName(value))
    override val targetLocationAlarmConfiguration
        : Optional[zio.aws.ssm.model.AlarmConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocationAlarmConfiguration())
        .map(value => zio.aws.ssm.model.AlarmConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.TargetLocation
  ): zio.aws.ssm.model.TargetLocation.ReadOnly = new Wrapper(impl)
}
