package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  PatchSourceConfiguration,
  PatchSourceProduct,
  PatchSourceName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PatchSource(
    name: PatchSourceName,
    products: Iterable[PatchSourceProduct],
    configuration: PatchSourceConfiguration
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.PatchSource = {
    import PatchSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchSource
      .builder()
      .name(PatchSourceName.unwrap(name): java.lang.String)
      .products(products.map { item =>
        PatchSourceProduct.unwrap(item): java.lang.String
      }.asJavaCollection)
      .configuration(
        PatchSourceConfiguration.unwrap(configuration): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchSource.ReadOnly =
    zio.aws.ssm.model.PatchSource.wrap(buildAwsValue())
}
object PatchSource {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.PatchSource] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchSource =
      zio.aws.ssm.model.PatchSource(name, products, configuration)
    def name: PatchSourceName
    def products: List[PatchSourceProduct]
    def configuration: PatchSourceConfiguration
    def getName: ZIO[Any, Nothing, PatchSourceName] = ZIO.succeed(name)
    def getProducts: ZIO[Any, Nothing, List[PatchSourceProduct]] =
      ZIO.succeed(products)
    def getConfiguration: ZIO[Any, Nothing, PatchSourceConfiguration] =
      ZIO.succeed(configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchSource
  ) extends zio.aws.ssm.model.PatchSource.ReadOnly {
    override val name: PatchSourceName =
      zio.aws.ssm.model.primitives.PatchSourceName(impl.name())
    override val products: List[PatchSourceProduct] = impl
      .products()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.PatchSourceProduct(item)
      }
      .toList
    override val configuration: PatchSourceConfiguration =
      zio.aws.ssm.model.primitives
        .PatchSourceConfiguration(impl.configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchSource
  ): zio.aws.ssm.model.PatchSource.ReadOnly = new Wrapper(impl)
}
