package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait OperatingSystem {
  def unwrap: software.amazon.awssdk.services.ssm.model.OperatingSystem
}
object OperatingSystem {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.OperatingSystem
  ): zio.aws.ssm.model.OperatingSystem = value match {
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.WINDOWS =>
      val r = WINDOWS
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.AMAZON_LINUX =>
      val r = AMAZON_LINUX
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.AMAZON_LINUX_2 =>
      val r = AMAZON_LINUX_2
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.AMAZON_LINUX_2022 =>
      val r = AMAZON_LINUX_2022
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.UBUNTU =>
      val r = UBUNTU
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.REDHAT_ENTERPRISE_LINUX =>
      val r = REDHAT_ENTERPRISE_LINUX
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.SUSE =>
      val r = SUSE
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.CENTOS =>
      val r = CENTOS
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.ORACLE_LINUX =>
      val r = ORACLE_LINUX
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.DEBIAN =>
      val r = DEBIAN
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.MACOS =>
      val r = MACOS
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.RASPBIAN =>
      val r = RASPBIAN
      r
    case software.amazon.awssdk.services.ssm.model.OperatingSystem.ROCKY_LINUX =>
      val r = ROCKY_LINUX
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.WINDOWS
  }
  case object AMAZON_LINUX extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.AMAZON_LINUX
  }
  case object AMAZON_LINUX_2 extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.AMAZON_LINUX_2
  }
  case object AMAZON_LINUX_2022 extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.AMAZON_LINUX_2022
  }
  case object UBUNTU extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.UBUNTU
  }
  case object REDHAT_ENTERPRISE_LINUX
      extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.REDHAT_ENTERPRISE_LINUX
  }
  case object SUSE extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.SUSE
  }
  case object CENTOS extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.CENTOS
  }
  case object ORACLE_LINUX extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.ORACLE_LINUX
  }
  case object DEBIAN extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.DEBIAN
  }
  case object MACOS extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.MACOS
  }
  case object RASPBIAN extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.RASPBIAN
  }
  case object ROCKY_LINUX extends zio.aws.ssm.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OperatingSystem =
      software.amazon.awssdk.services.ssm.model.OperatingSystem.ROCKY_LINUX
  }
}
