package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait MaintenanceWindowTaskType {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType
}
object MaintenanceWindowTaskType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType
  ): zio.aws.ssm.model.MaintenanceWindowTaskType = value match {
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType.RUN_COMMAND =>
      val r = RUN_COMMAND
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType.AUTOMATION =>
      val r = AUTOMATION
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType.STEP_FUNCTIONS =>
      val r = STEP_FUNCTIONS
      r
    case software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType.LAMBDA =>
      val r = LAMBDA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.MaintenanceWindowTaskType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType.UNKNOWN_TO_SDK_VERSION
  }
  case object RUN_COMMAND extends zio.aws.ssm.model.MaintenanceWindowTaskType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType.RUN_COMMAND
  }
  case object AUTOMATION extends zio.aws.ssm.model.MaintenanceWindowTaskType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType.AUTOMATION
  }
  case object STEP_FUNCTIONS
      extends zio.aws.ssm.model.MaintenanceWindowTaskType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType.STEP_FUNCTIONS
  }
  case object LAMBDA extends zio.aws.ssm.model.MaintenanceWindowTaskType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType =
      software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType.LAMBDA
  }
}
