package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.InstanceInformationFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InstanceInformationFilter(
    key: zio.aws.ssm.model.InstanceInformationFilterKey,
    valueSet: Iterable[InstanceInformationFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceInformationFilter = {
    import InstanceInformationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceInformationFilter
      .builder()
      .key(key.unwrap)
      .valueSet(valueSet.map { item =>
        InstanceInformationFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceInformationFilter.ReadOnly =
    zio.aws.ssm.model.InstanceInformationFilter.wrap(buildAwsValue())
}
object InstanceInformationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceInformationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceInformationFilter =
      zio.aws.ssm.model.InstanceInformationFilter(key, valueSet)
    def key: zio.aws.ssm.model.InstanceInformationFilterKey
    def valueSet: List[InstanceInformationFilterValue]
    def getKey
        : ZIO[Any, Nothing, zio.aws.ssm.model.InstanceInformationFilterKey] =
      ZIO.succeed(key)
    def getValueSet: ZIO[Any, Nothing, List[InstanceInformationFilterValue]] =
      ZIO.succeed(valueSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceInformationFilter
  ) extends zio.aws.ssm.model.InstanceInformationFilter.ReadOnly {
    override val key: zio.aws.ssm.model.InstanceInformationFilterKey =
      zio.aws.ssm.model.InstanceInformationFilterKey.wrap(impl.key())
    override val valueSet: List[InstanceInformationFilterValue] = impl
      .valueSet()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.InstanceInformationFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceInformationFilter
  ): zio.aws.ssm.model.InstanceInformationFilter.ReadOnly = new Wrapper(impl)
}
