package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AssociationVersion,
  DocumentContent,
  InstanceId,
  AssociationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceAssociation(
    associationId: Optional[AssociationId] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    content: Optional[DocumentContent] = Optional.Absent,
    associationVersion: Optional[AssociationVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceAssociation = {
    import InstanceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceAssociation
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        content.map(value => DocumentContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceAssociation.ReadOnly =
    zio.aws.ssm.model.InstanceAssociation.wrap(buildAwsValue())
}
object InstanceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceAssociation =
      zio.aws.ssm.model.InstanceAssociation(
        associationId.map(value => value),
        instanceId.map(value => value),
        content.map(value => value),
        associationVersion.map(value => value)
      )
    def associationId: Optional[AssociationId]
    def instanceId: Optional[InstanceId]
    def content: Optional[DocumentContent]
    def associationVersion: Optional[AssociationVersion]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getContent: ZIO[Any, AwsError, DocumentContent] =
      AwsError.unwrapOptionField("content", content)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociation
  ) extends zio.aws.ssm.model.InstanceAssociation.ReadOnly {
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val content: Optional[DocumentContent] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.ssm.model.primitives.DocumentContent(value))
    override val associationVersion: Optional[AssociationVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationVersion())
        .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociation
  ): zio.aws.ssm.model.InstanceAssociation.ReadOnly = new Wrapper(impl)
}
