package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeMaintenanceWindowTasksResponse(
    tasks: Optional[Iterable[zio.aws.ssm.model.MaintenanceWindowTask]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse = {
    import DescribeMaintenanceWindowTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse
      .builder()
      .optionallyWith(
        tasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tasks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse =
      zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse(
        tasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tasks: Optional[List[zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTasks: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly
    ]] = AwsError.unwrapOptionField("tasks", tasks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse.ReadOnly {
    override val tasks
        : Optional[List[zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.MaintenanceWindowTask.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse
  ): zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse.ReadOnly =
    new Wrapper(impl)
}
