package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait ComplianceQueryOperatorType {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType
}
object ComplianceQueryOperatorType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType
  ): zio.aws.ssm.model.ComplianceQueryOperatorType = value match {
    case software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.EQUAL =>
      val r = EQUAL
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.NOT_EQUAL =>
      val r = NOT_EQUAL
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.BEGIN_WITH =>
      val r = BEGIN_WITH
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.GREATER_THAN =>
      val r = GREATER_THAN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.ComplianceQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUAL extends zio.aws.ssm.model.ComplianceQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.EQUAL
  }
  case object NOT_EQUAL extends zio.aws.ssm.model.ComplianceQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.NOT_EQUAL
  }
  case object BEGIN_WITH extends zio.aws.ssm.model.ComplianceQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.BEGIN_WITH
  }
  case object LESS_THAN extends zio.aws.ssm.model.ComplianceQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.LESS_THAN
  }
  case object GREATER_THAN
      extends zio.aws.ssm.model.ComplianceQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.ComplianceQueryOperatorType.GREATER_THAN
  }
}
