package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AssociationExecutionTargetsFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociationExecutionTargetsFilter(
    key: zio.aws.ssm.model.AssociationExecutionTargetsFilterKey,
    value: AssociationExecutionTargetsFilterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilter = {
    import AssociationExecutionTargetsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilter
      .builder()
      .key(key.unwrap)
      .value(
        AssociationExecutionTargetsFilterValue.unwrap(value): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationExecutionTargetsFilter.ReadOnly =
    zio.aws.ssm.model.AssociationExecutionTargetsFilter.wrap(buildAwsValue())
}
object AssociationExecutionTargetsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationExecutionTargetsFilter =
      zio.aws.ssm.model.AssociationExecutionTargetsFilter(key, value)
    def key: zio.aws.ssm.model.AssociationExecutionTargetsFilterKey
    def value: AssociationExecutionTargetsFilterValue
    def getKey: ZIO[
      Any,
      Nothing,
      zio.aws.ssm.model.AssociationExecutionTargetsFilterKey
    ] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, AssociationExecutionTargetsFilterValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilter
  ) extends zio.aws.ssm.model.AssociationExecutionTargetsFilter.ReadOnly {
    override val key: zio.aws.ssm.model.AssociationExecutionTargetsFilterKey =
      zio.aws.ssm.model.AssociationExecutionTargetsFilterKey.wrap(impl.key())
    override val value: AssociationExecutionTargetsFilterValue =
      zio.aws.ssm.model.primitives
        .AssociationExecutionTargetsFilterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilter
  ): zio.aws.ssm.model.AssociationExecutionTargetsFilter.ReadOnly = new Wrapper(
    impl
  )
}
