package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{Reviewer, DateTime}
import scala.jdk.CollectionConverters._
final case class ReviewInformation(
    reviewedTime: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.ReviewStatus] = Optional.Absent,
    reviewer: Optional[Reviewer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ReviewInformation = {
    import ReviewInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ReviewInformation
      .builder()
      .optionallyWith(
        reviewedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.reviewedTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        reviewer.map(value => Reviewer.unwrap(value): java.lang.String)
      )(_.reviewer)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ReviewInformation.ReadOnly =
    zio.aws.ssm.model.ReviewInformation.wrap(buildAwsValue())
}
object ReviewInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ReviewInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ReviewInformation =
      zio.aws.ssm.model.ReviewInformation(
        reviewedTime.map(value => value),
        status.map(value => value),
        reviewer.map(value => value)
      )
    def reviewedTime: Optional[DateTime]
    def status: Optional[zio.aws.ssm.model.ReviewStatus]
    def reviewer: Optional[Reviewer]
    def getReviewedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("reviewedTime", reviewedTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ReviewStatus] =
      AwsError.unwrapOptionField("status", status)
    def getReviewer: ZIO[Any, AwsError, Reviewer] =
      AwsError.unwrapOptionField("reviewer", reviewer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ReviewInformation
  ) extends zio.aws.ssm.model.ReviewInformation.ReadOnly {
    override val reviewedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.reviewedTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.ssm.model.ReviewStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.ReviewStatus.wrap(value))
    override val reviewer: Optional[Reviewer] = zio.aws.core.internal
      .optionalFromNullable(impl.reviewer())
      .map(value => zio.aws.ssm.model.primitives.Reviewer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ReviewInformation
  ): zio.aws.ssm.model.ReviewInformation.ReadOnly = new Wrapper(impl)
}
