package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait DocumentMetadataEnum {
  def unwrap: software.amazon.awssdk.services.ssm.model.DocumentMetadataEnum
}
object DocumentMetadataEnum {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DocumentMetadataEnum
  ): zio.aws.ssm.model.DocumentMetadataEnum = value match {
    case software.amazon.awssdk.services.ssm.model.DocumentMetadataEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DocumentMetadataEnum.DOCUMENT_REVIEWS =>
      val r = DocumentReviews
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.DocumentMetadataEnum {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentMetadataEnum =
      software.amazon.awssdk.services.ssm.model.DocumentMetadataEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object DocumentReviews extends zio.aws.ssm.model.DocumentMetadataEnum {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentMetadataEnum =
      software.amazon.awssdk.services.ssm.model.DocumentMetadataEnum.DOCUMENT_REVIEWS
  }
}
