package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.SessionFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SessionFilter(
    key: zio.aws.ssm.model.SessionFilterKey,
    value: SessionFilterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.SessionFilter = {
    import SessionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.SessionFilter
      .builder()
      .key(key.unwrap)
      .value(SessionFilterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.SessionFilter.ReadOnly =
    zio.aws.ssm.model.SessionFilter.wrap(buildAwsValue())
}
object SessionFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.SessionFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.SessionFilter =
      zio.aws.ssm.model.SessionFilter(key, value)
    def key: zio.aws.ssm.model.SessionFilterKey
    def value: SessionFilterValue
    def getKey: ZIO[Any, Nothing, zio.aws.ssm.model.SessionFilterKey] =
      ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, SessionFilterValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.SessionFilter
  ) extends zio.aws.ssm.model.SessionFilter.ReadOnly {
    override val key: zio.aws.ssm.model.SessionFilterKey =
      zio.aws.ssm.model.SessionFilterKey.wrap(impl.key())
    override val value: SessionFilterValue =
      zio.aws.ssm.model.primitives.SessionFilterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.SessionFilter
  ): zio.aws.ssm.model.SessionFilter.ReadOnly = new Wrapper(impl)
}
