package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PSParameterName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetParametersRequest(
    names: Iterable[PSParameterName],
    withDecryption: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetParametersRequest = {
    import GetParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetParametersRequest
      .builder()
      .names(names.map { item =>
        PSParameterName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(withDecryption.map(value => value: java.lang.Boolean))(
        _.withDecryption
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetParametersRequest.ReadOnly =
    zio.aws.ssm.model.GetParametersRequest.wrap(buildAwsValue())
}
object GetParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetParametersRequest = zio.aws.ssm.model
      .GetParametersRequest(names, withDecryption.map(value => value))
    def names: List[PSParameterName]
    def withDecryption: Optional[Boolean]
    def getNames: ZIO[Any, Nothing, List[PSParameterName]] = ZIO.succeed(names)
    def getWithDecryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("withDecryption", withDecryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetParametersRequest
  ) extends zio.aws.ssm.model.GetParametersRequest.ReadOnly {
    override val names: List[PSParameterName] = impl
      .names()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.PSParameterName(item)
      }
      .toList
    override val withDecryption: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.withDecryption())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetParametersRequest
  ): zio.aws.ssm.model.GetParametersRequest.ReadOnly = new Wrapper(impl)
}
