package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsItemArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateOpsItemResponse(
    opsItemId: Optional[String] = Optional.Absent,
    opsItemArn: Optional[OpsItemArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateOpsItemResponse = {
    import CreateOpsItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateOpsItemResponse
      .builder()
      .optionallyWith(opsItemId.map(value => value: java.lang.String))(
        _.opsItemId
      )
      .optionallyWith(
        opsItemArn.map(value => OpsItemArn.unwrap(value): java.lang.String)
      )(_.opsItemArn)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateOpsItemResponse.ReadOnly =
    zio.aws.ssm.model.CreateOpsItemResponse.wrap(buildAwsValue())
}
object CreateOpsItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateOpsItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateOpsItemResponse =
      zio.aws.ssm.model.CreateOpsItemResponse(
        opsItemId.map(value => value),
        opsItemArn.map(value => value)
      )
    def opsItemId: Optional[String]
    def opsItemArn: Optional[OpsItemArn]
    def getOpsItemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getOpsItemArn: ZIO[Any, AwsError, OpsItemArn] =
      AwsError.unwrapOptionField("opsItemArn", opsItemArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateOpsItemResponse
  ) extends zio.aws.ssm.model.CreateOpsItemResponse.ReadOnly {
    override val opsItemId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemId())
      .map(value => value: String)
    override val opsItemArn: Optional[OpsItemArn] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemArn())
      .map(value => zio.aws.ssm.model.primitives.OpsItemArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateOpsItemResponse
  ): zio.aws.ssm.model.CreateOpsItemResponse.ReadOnly = new Wrapper(impl)
}
