package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDocumentVersionsResponse(
    documentVersions: Optional[
      Iterable[zio.aws.ssm.model.DocumentVersionInfo]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse = {
    import ListDocumentVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse
      .builder()
      .optionallyWith(
        documentVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentVersions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListDocumentVersionsResponse.ReadOnly =
    zio.aws.ssm.model.ListDocumentVersionsResponse.wrap(buildAwsValue())
}
object ListDocumentVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListDocumentVersionsResponse =
      zio.aws.ssm.model.ListDocumentVersionsResponse(
        documentVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def documentVersions
        : Optional[List[zio.aws.ssm.model.DocumentVersionInfo.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDocumentVersions: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentVersionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("documentVersions", documentVersions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse
  ) extends zio.aws.ssm.model.ListDocumentVersionsResponse.ReadOnly {
    override val documentVersions
        : Optional[List[zio.aws.ssm.model.DocumentVersionInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentVersionInfo.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse
  ): zio.aws.ssm.model.ListDocumentVersionsResponse.ReadOnly = new Wrapper(impl)
}
