package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{ISO8601String, CalendarNameOrARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCalendarStateRequest(
    calendarNames: Iterable[CalendarNameOrARN],
    atTime: Optional[ISO8601String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetCalendarStateRequest = {
    import GetCalendarStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetCalendarStateRequest
      .builder()
      .calendarNames(calendarNames.map { item =>
        CalendarNameOrARN.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        atTime.map(value => ISO8601String.unwrap(value): java.lang.String)
      )(_.atTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetCalendarStateRequest.ReadOnly =
    zio.aws.ssm.model.GetCalendarStateRequest.wrap(buildAwsValue())
}
object GetCalendarStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetCalendarStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetCalendarStateRequest =
      zio.aws.ssm.model
        .GetCalendarStateRequest(calendarNames, atTime.map(value => value))
    def calendarNames: List[CalendarNameOrARN]
    def atTime: Optional[ISO8601String]
    def getCalendarNames: ZIO[Any, Nothing, List[CalendarNameOrARN]] =
      ZIO.succeed(calendarNames)
    def getAtTime: ZIO[Any, AwsError, ISO8601String] =
      AwsError.unwrapOptionField("atTime", atTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetCalendarStateRequest
  ) extends zio.aws.ssm.model.GetCalendarStateRequest.ReadOnly {
    override val calendarNames: List[CalendarNameOrARN] = impl
      .calendarNames()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.CalendarNameOrARN(item)
      }
      .toList
    override val atTime: Optional[ISO8601String] = zio.aws.core.internal
      .optionalFromNullable(impl.atTime())
      .map(value => zio.aws.ssm.model.primitives.ISO8601String(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetCalendarStateRequest
  ): zio.aws.ssm.model.GetCalendarStateRequest.ReadOnly = new Wrapper(impl)
}
