package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ActivationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteActivationRequest(activationId: ActivationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteActivationRequest = {
    import DeleteActivationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteActivationRequest
      .builder()
      .activationId(ActivationId.unwrap(activationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteActivationRequest.ReadOnly =
    zio.aws.ssm.model.DeleteActivationRequest.wrap(buildAwsValue())
}
object DeleteActivationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteActivationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteActivationRequest =
      zio.aws.ssm.model.DeleteActivationRequest(activationId)
    def activationId: ActivationId
    def getActivationId: ZIO[Any, Nothing, ActivationId] =
      ZIO.succeed(activationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteActivationRequest
  ) extends zio.aws.ssm.model.DeleteActivationRequest.ReadOnly {
    override val activationId: ActivationId =
      zio.aws.ssm.model.primitives.ActivationId(impl.activationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteActivationRequest
  ): zio.aws.ssm.model.DeleteActivationRequest.ReadOnly = new Wrapper(impl)
}
