package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PatchGroup
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPatchBaselineForPatchGroupRequest(
    patchGroup: PatchGroup,
    operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest = {
    import GetPatchBaselineForPatchGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest
      .builder()
      .patchGroup(PatchGroup.unwrap(patchGroup): java.lang.String)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetPatchBaselineForPatchGroupRequest.ReadOnly =
    zio.aws.ssm.model.GetPatchBaselineForPatchGroupRequest.wrap(buildAwsValue())
}
object GetPatchBaselineForPatchGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetPatchBaselineForPatchGroupRequest =
      zio.aws.ssm.model.GetPatchBaselineForPatchGroupRequest(
        patchGroup,
        operatingSystem.map(value => value)
      )
    def patchGroup: PatchGroup
    def operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem]
    def getPatchGroup: ZIO[Any, Nothing, PatchGroup] = ZIO.succeed(patchGroup)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.ssm.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest
  ) extends zio.aws.ssm.model.GetPatchBaselineForPatchGroupRequest.ReadOnly {
    override val patchGroup: PatchGroup =
      zio.aws.ssm.model.primitives.PatchGroup(impl.patchGroup())
    override val operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.ssm.model.OperatingSystem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest
  ): zio.aws.ssm.model.GetPatchBaselineForPatchGroupRequest.ReadOnly =
    new Wrapper(impl)
}
