package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  TargetMapValue,
  AutomationParameterValue,
  TargetMapKey,
  DocumentARN,
  DocumentVersion,
  AutomationParameterKey,
  MaxConcurrency,
  MaxErrors
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Runbook(
    documentName: DocumentARN,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    parameters: Optional[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = Optional.Absent,
    targetParameterName: Optional[AutomationParameterKey] = Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    targetMaps: Optional[
      Iterable[Map[TargetMapKey, Iterable[TargetMapValue]]]
    ] = Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    maxErrors: Optional[MaxErrors] = Optional.Absent,
    targetLocations: Optional[Iterable[zio.aws.ssm.model.TargetLocation]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Runbook = {
    import Runbook.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Runbook
      .builder()
      .documentName(DocumentARN.unwrap(documentName): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        targetParameterName.map(value =>
          AutomationParameterKey.unwrap(value): java.lang.String
        )
      )(_.targetParameterName)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        targetMaps.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TargetMapKey.unwrap(key): java.lang.String) -> value.map {
                  item =>
                    TargetMapValue.unwrap(item): java.lang.String
                }.asJavaCollection
              })
              .asJava
          }.asJavaCollection
        )
      )(_.targetMaps)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        targetLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetLocations)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Runbook.ReadOnly =
    zio.aws.ssm.model.Runbook.wrap(buildAwsValue())
}
object Runbook {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Runbook] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Runbook = zio.aws.ssm.model.Runbook(
      documentName,
      documentVersion.map(value => value),
      parameters.map(value => value),
      targetParameterName.map(value => value),
      targets.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      targetMaps.map(value => value),
      maxConcurrency.map(value => value),
      maxErrors.map(value => value),
      targetLocations.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def documentName: DocumentARN
    def documentVersion: Optional[DocumentVersion]
    def parameters
        : Optional[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def targetParameterName: Optional[AutomationParameterKey]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def targetMaps: Optional[List[Map[TargetMapKey, List[TargetMapValue]]]]
    def maxConcurrency: Optional[MaxConcurrency]
    def maxErrors: Optional[MaxErrors]
    def targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]]
    def getDocumentName: ZIO[Any, Nothing, DocumentARN] =
      ZIO.succeed(documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getParameters: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getTargetParameterName: ZIO[Any, AwsError, AutomationParameterKey] =
      AwsError.unwrapOptionField("targetParameterName", targetParameterName)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTargetMaps
        : ZIO[Any, AwsError, List[Map[TargetMapKey, List[TargetMapValue]]]] =
      AwsError.unwrapOptionField("targetMaps", targetMaps)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getTargetLocations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      AwsError.unwrapOptionField("targetLocations", targetLocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Runbook
  ) extends zio.aws.ssm.model.Runbook.ReadOnly {
    override val documentName: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.documentName())
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val parameters: Optional[
      Map[AutomationParameterKey, List[AutomationParameterValue]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives
              .AutomationParameterKey(key) -> value.asScala.map { item =>
              zio.aws.ssm.model.primitives.AutomationParameterValue(item)
            }.toList
          })
          .toMap
      )
    override val targetParameterName: Optional[AutomationParameterKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetParameterName())
        .map(value =>
          zio.aws.ssm.model.primitives.AutomationParameterKey(value)
        )
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val targetMaps
        : Optional[List[Map[TargetMapKey, List[TargetMapValue]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetMaps())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.ssm.model.primitives
                  .TargetMapKey(key) -> value.asScala.map { item =>
                  zio.aws.ssm.model.primitives.TargetMapValue(item)
                }.toList
              })
              .toMap
          }.toList
        )
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.TargetLocation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Runbook
  ): zio.aws.ssm.model.Runbook.ReadOnly = new Wrapper(impl)
}
