package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PSParameterName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetParametersResponse(
    parameters: Optional[Iterable[zio.aws.ssm.model.Parameter]] =
      Optional.Absent,
    invalidParameters: Optional[Iterable[PSParameterName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetParametersResponse = {
    import GetParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetParametersResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        invalidParameters.map(value =>
          value.map { item =>
            PSParameterName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.invalidParameters)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetParametersResponse.ReadOnly =
    zio.aws.ssm.model.GetParametersResponse.wrap(buildAwsValue())
}
object GetParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetParametersResponse =
      zio.aws.ssm.model.GetParametersResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        invalidParameters.map(value => value)
      )
    def parameters: Optional[List[zio.aws.ssm.model.Parameter.ReadOnly]]
    def invalidParameters: Optional[List[PSParameterName]]
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getInvalidParameters: ZIO[Any, AwsError, List[PSParameterName]] =
      AwsError.unwrapOptionField("invalidParameters", invalidParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetParametersResponse
  ) extends zio.aws.ssm.model.GetParametersResponse.ReadOnly {
    override val parameters
        : Optional[List[zio.aws.ssm.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Parameter.wrap(item)
          }.toList
        )
    override val invalidParameters: Optional[List[PSParameterName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PSParameterName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetParametersResponse
  ): zio.aws.ssm.model.GetParametersResponse.ReadOnly = new Wrapper(impl)
}
