package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait ExternalAlarmState {
  def unwrap: software.amazon.awssdk.services.ssm.model.ExternalAlarmState
}
object ExternalAlarmState {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ExternalAlarmState
  ): zio.aws.ssm.model.ExternalAlarmState = value match {
    case software.amazon.awssdk.services.ssm.model.ExternalAlarmState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ExternalAlarmState.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.ssm.model.ExternalAlarmState.ALARM =>
      val r = ALARM
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.ExternalAlarmState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ExternalAlarmState =
      software.amazon.awssdk.services.ssm.model.ExternalAlarmState.UNKNOWN_TO_SDK_VERSION
  }
  case object UNKNOWN extends zio.aws.ssm.model.ExternalAlarmState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ExternalAlarmState =
      software.amazon.awssdk.services.ssm.model.ExternalAlarmState.UNKNOWN
  }
  case object ALARM extends zio.aws.ssm.model.ExternalAlarmState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ExternalAlarmState =
      software.amazon.awssdk.services.ssm.model.ExternalAlarmState.ALARM
  }
}
