package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait AutomationType {
  def unwrap: software.amazon.awssdk.services.ssm.model.AutomationType
}
object AutomationType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AutomationType
  ): zio.aws.ssm.model.AutomationType = value match {
    case software.amazon.awssdk.services.ssm.model.AutomationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AutomationType.CROSS_ACCOUNT =>
      val r = CrossAccount
      r
    case software.amazon.awssdk.services.ssm.model.AutomationType.LOCAL =>
      val r = Local
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.AutomationType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationType =
      software.amazon.awssdk.services.ssm.model.AutomationType.UNKNOWN_TO_SDK_VERSION
  }
  case object CrossAccount extends zio.aws.ssm.model.AutomationType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationType =
      software.amazon.awssdk.services.ssm.model.AutomationType.CROSS_ACCOUNT
  }
  case object Local extends zio.aws.ssm.model.AutomationType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationType =
      software.amazon.awssdk.services.ssm.model.AutomationType.LOCAL
  }
}
