package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ParameterLabel,
  PSParameterVersion,
  PSParameterName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LabelParameterVersionRequest(
    name: PSParameterName,
    parameterVersion: Optional[PSParameterVersion] = Optional.Absent,
    labels: Iterable[ParameterLabel]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.LabelParameterVersionRequest = {
    import LabelParameterVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.LabelParameterVersionRequest
      .builder()
      .name(PSParameterName.unwrap(name): java.lang.String)
      .optionallyWith(
        parameterVersion.map(value =>
          PSParameterVersion.unwrap(value): java.lang.Long
        )
      )(_.parameterVersion)
      .labels(labels.map { item =>
        ParameterLabel.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.LabelParameterVersionRequest.ReadOnly =
    zio.aws.ssm.model.LabelParameterVersionRequest.wrap(buildAwsValue())
}
object LabelParameterVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.LabelParameterVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.LabelParameterVersionRequest =
      zio.aws.ssm.model.LabelParameterVersionRequest(
        name,
        parameterVersion.map(value => value),
        labels
      )
    def name: PSParameterName
    def parameterVersion: Optional[PSParameterVersion]
    def labels: List[ParameterLabel]
    def getName: ZIO[Any, Nothing, PSParameterName] = ZIO.succeed(name)
    def getParameterVersion: ZIO[Any, AwsError, PSParameterVersion] =
      AwsError.unwrapOptionField("parameterVersion", parameterVersion)
    def getLabels: ZIO[Any, Nothing, List[ParameterLabel]] = ZIO.succeed(labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.LabelParameterVersionRequest
  ) extends zio.aws.ssm.model.LabelParameterVersionRequest.ReadOnly {
    override val name: PSParameterName =
      zio.aws.ssm.model.primitives.PSParameterName(impl.name())
    override val parameterVersion: Optional[PSParameterVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterVersion())
        .map(value => zio.aws.ssm.model.primitives.PSParameterVersion(value))
    override val labels: List[ParameterLabel] = impl
      .labels()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.ParameterLabel(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.LabelParameterVersionRequest
  ): zio.aws.ssm.model.LabelParameterVersionRequest.ReadOnly = new Wrapper(impl)
}
