package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  InventoryTypeDisplayName,
  InventoryItemSchemaVersion,
  InventoryItemTypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InventoryItemSchema(
    typeName: InventoryItemTypeName,
    version: Optional[InventoryItemSchemaVersion] = Optional.Absent,
    attributes: Iterable[zio.aws.ssm.model.InventoryItemAttribute],
    displayName: Optional[InventoryTypeDisplayName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryItemSchema = {
    import InventoryItemSchema.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryItemSchema
      .builder()
      .typeName(InventoryItemTypeName.unwrap(typeName): java.lang.String)
      .optionallyWith(
        version.map(value =>
          InventoryItemSchemaVersion.unwrap(value): java.lang.String
        )
      )(_.version)
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        displayName.map(value =>
          InventoryTypeDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryItemSchema.ReadOnly =
    zio.aws.ssm.model.InventoryItemSchema.wrap(buildAwsValue())
}
object InventoryItemSchema {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryItemSchema
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryItemSchema =
      zio.aws.ssm.model.InventoryItemSchema(
        typeName,
        version.map(value => value),
        attributes.map { item =>
          item.asEditable
        },
        displayName.map(value => value)
      )
    def typeName: InventoryItemTypeName
    def version: Optional[InventoryItemSchemaVersion]
    def attributes: List[zio.aws.ssm.model.InventoryItemAttribute.ReadOnly]
    def displayName: Optional[InventoryTypeDisplayName]
    def getTypeName: ZIO[Any, Nothing, InventoryItemTypeName] =
      ZIO.succeed(typeName)
    def getVersion: ZIO[Any, AwsError, InventoryItemSchemaVersion] =
      AwsError.unwrapOptionField("version", version)
    def getAttributes: ZIO[Any, Nothing, List[
      zio.aws.ssm.model.InventoryItemAttribute.ReadOnly
    ]] = ZIO.succeed(attributes)
    def getDisplayName: ZIO[Any, AwsError, InventoryTypeDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryItemSchema
  ) extends zio.aws.ssm.model.InventoryItemSchema.ReadOnly {
    override val typeName: InventoryItemTypeName =
      zio.aws.ssm.model.primitives.InventoryItemTypeName(impl.typeName())
    override val version: Optional[InventoryItemSchemaVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.version())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryItemSchemaVersion(value)
        )
    override val attributes
        : List[zio.aws.ssm.model.InventoryItemAttribute.ReadOnly] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.ssm.model.InventoryItemAttribute.wrap(item)
      }
      .toList
    override val displayName: Optional[InventoryTypeDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryTypeDisplayName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryItemSchema
  ): zio.aws.ssm.model.InventoryItemSchema.ReadOnly = new Wrapper(impl)
}
