package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{InventoryFilterValue, InventoryFilterKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InventoryFilter(
    key: InventoryFilterKey,
    values: Iterable[InventoryFilterValue],
    `type`: Optional[zio.aws.ssm.model.InventoryQueryOperatorType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryFilter = {
    import InventoryFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryFilter
      .builder()
      .key(InventoryFilterKey.unwrap(key): java.lang.String)
      .values(values.map { item =>
        InventoryFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryFilter.ReadOnly =
    zio.aws.ssm.model.InventoryFilter.wrap(buildAwsValue())
}
object InventoryFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryFilter =
      zio.aws.ssm.model.InventoryFilter(key, values, `type`.map(value => value))
    def key: InventoryFilterKey
    def values: List[InventoryFilterValue]
    def `type`: Optional[zio.aws.ssm.model.InventoryQueryOperatorType]
    def getKey: ZIO[Any, Nothing, InventoryFilterKey] = ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[InventoryFilterValue]] =
      ZIO.succeed(values)
    def getType
        : ZIO[Any, AwsError, zio.aws.ssm.model.InventoryQueryOperatorType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryFilter
  ) extends zio.aws.ssm.model.InventoryFilter.ReadOnly {
    override val key: InventoryFilterKey =
      zio.aws.ssm.model.primitives.InventoryFilterKey(impl.key())
    override val values: List[InventoryFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.InventoryFilterValue(item)
      }
      .toList
    override val `type`
        : Optional[zio.aws.ssm.model.InventoryQueryOperatorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ssm.model.InventoryQueryOperatorType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryFilter
  ): zio.aws.ssm.model.InventoryFilter.ReadOnly = new Wrapper(impl)
}
