package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.BaselineId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDefaultPatchBaselineResponse(
    baselineId: Optional[BaselineId] = Optional.Absent,
    operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse = {
    import GetDefaultPatchBaselineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse
      .builder()
      .optionallyWith(
        baselineId.map(value => BaselineId.unwrap(value): java.lang.String)
      )(_.baselineId)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetDefaultPatchBaselineResponse.ReadOnly =
    zio.aws.ssm.model.GetDefaultPatchBaselineResponse.wrap(buildAwsValue())
}
object GetDefaultPatchBaselineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetDefaultPatchBaselineResponse =
      zio.aws.ssm.model.GetDefaultPatchBaselineResponse(
        baselineId.map(value => value),
        operatingSystem.map(value => value)
      )
    def baselineId: Optional[BaselineId]
    def operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem]
    def getBaselineId: ZIO[Any, AwsError, BaselineId] =
      AwsError.unwrapOptionField("baselineId", baselineId)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.ssm.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse
  ) extends zio.aws.ssm.model.GetDefaultPatchBaselineResponse.ReadOnly {
    override val baselineId: Optional[BaselineId] = zio.aws.core.internal
      .optionalFromNullable(impl.baselineId())
      .map(value => zio.aws.ssm.model.primitives.BaselineId(value))
    override val operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.ssm.model.OperatingSystem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse
  ): zio.aws.ssm.model.GetDefaultPatchBaselineResponse.ReadOnly = new Wrapper(
    impl
  )
}
