package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{NextToken, PatchBaselineMaxResults}
import scala.jdk.CollectionConverters._
final case class DescribePatchGroupsRequest(
    maxResults: Optional[PatchBaselineMaxResults] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ssm.model.PatchOrchestratorFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest = {
    import DescribePatchGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => PatchBaselineMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchGroupsRequest.ReadOnly =
    zio.aws.ssm.model.DescribePatchGroupsRequest.wrap(buildAwsValue())
}
object DescribePatchGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchGroupsRequest =
      zio.aws.ssm.model.DescribePatchGroupsRequest(
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def maxResults: Optional[PatchBaselineMaxResults]
    def filters
        : Optional[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, PatchBaselineMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest
  ) extends zio.aws.ssm.model.DescribePatchGroupsRequest.ReadOnly {
    override val maxResults: Optional[PatchBaselineMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.PatchBaselineMaxResults(value)
        )
    override val filters
        : Optional[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchOrchestratorFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest
  ): zio.aws.ssm.model.DescribePatchGroupsRequest.ReadOnly = new Wrapper(impl)
}
