package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteMaintenanceWindowResponse(
    windowId: Optional[MaintenanceWindowId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse = {
    import DeleteMaintenanceWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteMaintenanceWindowResponse.ReadOnly =
    zio.aws.ssm.model.DeleteMaintenanceWindowResponse.wrap(buildAwsValue())
}
object DeleteMaintenanceWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteMaintenanceWindowResponse =
      zio.aws.ssm.model
        .DeleteMaintenanceWindowResponse(windowId.map(value => value))
    def windowId: Optional[MaintenanceWindowId]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse
  ) extends zio.aws.ssm.model.DeleteMaintenanceWindowResponse.ReadOnly {
    override val windowId: Optional[MaintenanceWindowId] = zio.aws.core.internal
      .optionalFromNullable(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse
  ): zio.aws.ssm.model.DeleteMaintenanceWindowResponse.ReadOnly = new Wrapper(
    impl
  )
}
