package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait ComplianceSeverity {
  def unwrap: software.amazon.awssdk.services.ssm.model.ComplianceSeverity
}
object ComplianceSeverity {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ComplianceSeverity
  ): zio.aws.ssm.model.ComplianceSeverity = value match {
    case software.amazon.awssdk.services.ssm.model.ComplianceSeverity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceSeverity.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceSeverity.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceSeverity.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceSeverity.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceSeverity.INFORMATIONAL =>
      val r = INFORMATIONAL
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceSeverity.UNSPECIFIED =>
      val r = UNSPECIFIED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.ComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.ComplianceSeverity.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.ssm.model.ComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.ComplianceSeverity.CRITICAL
  }
  case object HIGH extends zio.aws.ssm.model.ComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.ComplianceSeverity.HIGH
  }
  case object MEDIUM extends zio.aws.ssm.model.ComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.ComplianceSeverity.MEDIUM
  }
  case object LOW extends zio.aws.ssm.model.ComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.ComplianceSeverity.LOW
  }
  case object INFORMATIONAL extends zio.aws.ssm.model.ComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.ComplianceSeverity.INFORMATIONAL
  }
  case object UNSPECIFIED extends zio.aws.ssm.model.ComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.ComplianceSeverity.UNSPECIFIED
  }
}
