package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{S3KeyPrefix, S3BucketName, S3Region}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3OutputLocation(
    outputS3Region: Optional[S3Region] = Optional.Absent,
    outputS3BucketName: Optional[S3BucketName] = Optional.Absent,
    outputS3KeyPrefix: Optional[S3KeyPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.S3OutputLocation = {
    import S3OutputLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.S3OutputLocation
      .builder()
      .optionallyWith(
        outputS3Region.map(value => S3Region.unwrap(value): java.lang.String)
      )(_.outputS3Region)
      .optionallyWith(
        outputS3BucketName.map(value =>
          S3BucketName.unwrap(value): java.lang.String
        )
      )(_.outputS3BucketName)
      .optionallyWith(
        outputS3KeyPrefix.map(value =>
          S3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.outputS3KeyPrefix)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.S3OutputLocation.ReadOnly =
    zio.aws.ssm.model.S3OutputLocation.wrap(buildAwsValue())
}
object S3OutputLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.S3OutputLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.S3OutputLocation =
      zio.aws.ssm.model.S3OutputLocation(
        outputS3Region.map(value => value),
        outputS3BucketName.map(value => value),
        outputS3KeyPrefix.map(value => value)
      )
    def outputS3Region: Optional[S3Region]
    def outputS3BucketName: Optional[S3BucketName]
    def outputS3KeyPrefix: Optional[S3KeyPrefix]
    def getOutputS3Region: ZIO[Any, AwsError, S3Region] =
      AwsError.unwrapOptionField("outputS3Region", outputS3Region)
    def getOutputS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("outputS3BucketName", outputS3BucketName)
    def getOutputS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("outputS3KeyPrefix", outputS3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.S3OutputLocation
  ) extends zio.aws.ssm.model.S3OutputLocation.ReadOnly {
    override val outputS3Region: Optional[S3Region] = zio.aws.core.internal
      .optionalFromNullable(impl.outputS3Region())
      .map(value => zio.aws.ssm.model.primitives.S3Region(value))
    override val outputS3BucketName: Optional[S3BucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3BucketName())
        .map(value => zio.aws.ssm.model.primitives.S3BucketName(value))
    override val outputS3KeyPrefix: Optional[S3KeyPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3KeyPrefix())
        .map(value => zio.aws.ssm.model.primitives.S3KeyPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.S3OutputLocation
  ): zio.aws.ssm.model.S3OutputLocation.ReadOnly = new Wrapper(impl)
}
