package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AutomationExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAutomationExecutionRequest(
    automationExecutionId: AutomationExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest = {
    import GetAutomationExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest
      .builder()
      .automationExecutionId(
        AutomationExecutionId.unwrap(automationExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetAutomationExecutionRequest.ReadOnly =
    zio.aws.ssm.model.GetAutomationExecutionRequest.wrap(buildAwsValue())
}
object GetAutomationExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetAutomationExecutionRequest =
      zio.aws.ssm.model.GetAutomationExecutionRequest(automationExecutionId)
    def automationExecutionId: AutomationExecutionId
    def getAutomationExecutionId: ZIO[Any, Nothing, AutomationExecutionId] =
      ZIO.succeed(automationExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest
  ) extends zio.aws.ssm.model.GetAutomationExecutionRequest.ReadOnly {
    override val automationExecutionId: AutomationExecutionId =
      zio.aws.ssm.model.primitives
        .AutomationExecutionId(impl.automationExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest
  ): zio.aws.ssm.model.GetAutomationExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
