package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{NextToken, SessionMaxResults}
import scala.jdk.CollectionConverters._
final case class DescribeSessionsRequest(
    state: zio.aws.ssm.model.SessionState,
    maxResults: Optional[SessionMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ssm.model.SessionFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest = {
    import DescribeSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest
      .builder()
      .state(state.unwrap)
      .optionallyWith(
        maxResults.map(value => SessionMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeSessionsRequest.ReadOnly =
    zio.aws.ssm.model.DescribeSessionsRequest.wrap(buildAwsValue())
}
object DescribeSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeSessionsRequest =
      zio.aws.ssm.model.DescribeSessionsRequest(
        state,
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def state: zio.aws.ssm.model.SessionState
    def maxResults: Optional[SessionMaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ssm.model.SessionFilter.ReadOnly]]
    def getState: ZIO[Any, Nothing, zio.aws.ssm.model.SessionState] =
      ZIO.succeed(state)
    def getMaxResults: ZIO[Any, AwsError, SessionMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.SessionFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest
  ) extends zio.aws.ssm.model.DescribeSessionsRequest.ReadOnly {
    override val state: zio.aws.ssm.model.SessionState =
      zio.aws.ssm.model.SessionState.wrap(impl.state())
    override val maxResults: Optional[SessionMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.SessionMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val filters
        : Optional[List[zio.aws.ssm.model.SessionFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.SessionFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest
  ): zio.aws.ssm.model.DescribeSessionsRequest.ReadOnly = new Wrapper(impl)
}
