package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeMaintenanceWindowExecutionTasksResponse(
    windowExecutionTaskIdentities: Optional[
      Iterable[zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse = {
    import DescribeMaintenanceWindowExecutionTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse
      .builder()
      .optionallyWith(
        windowExecutionTaskIdentities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.windowExecutionTaskIdentities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowExecutionTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse =
      zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse(
        windowExecutionTaskIdentities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def windowExecutionTaskIdentities: Optional[
      List[zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getWindowExecutionTaskIdentities: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "windowExecutionTaskIdentities",
      windowExecutionTaskIdentities
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse.ReadOnly {
    override val windowExecutionTaskIdentities: Optional[
      List[zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.windowExecutionTaskIdentities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse
  ): zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse.ReadOnly =
    new Wrapper(impl)
}
