package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeActivationsResponse(
    activationList: Optional[Iterable[zio.aws.ssm.model.Activation]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse = {
    import DescribeActivationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse
      .builder()
      .optionallyWith(
        activationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activationList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeActivationsResponse.wrap(buildAwsValue())
}
object DescribeActivationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeActivationsResponse =
      zio.aws.ssm.model.DescribeActivationsResponse(
        activationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def activationList: Optional[List[zio.aws.ssm.model.Activation.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getActivationList
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Activation.ReadOnly]] =
      AwsError.unwrapOptionField("activationList", activationList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse
  ) extends zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly {
    override val activationList
        : Optional[List[zio.aws.ssm.model.Activation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activationList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Activation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse
  ): zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly = new Wrapper(impl)
}
