package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{PatchGroup, BaselineId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPatchBaselineForPatchGroupResponse(
    baselineId: Optional[BaselineId] = Optional.Absent,
    patchGroup: Optional[PatchGroup] = Optional.Absent,
    operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse = {
    import GetPatchBaselineForPatchGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse
      .builder()
      .optionallyWith(
        baselineId.map(value => BaselineId.unwrap(value): java.lang.String)
      )(_.baselineId)
      .optionallyWith(
        patchGroup.map(value => PatchGroup.unwrap(value): java.lang.String)
      )(_.patchGroup)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse.ReadOnly =
    zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse
      .wrap(buildAwsValue())
}
object GetPatchBaselineForPatchGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse =
      zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse(
        baselineId.map(value => value),
        patchGroup.map(value => value),
        operatingSystem.map(value => value)
      )
    def baselineId: Optional[BaselineId]
    def patchGroup: Optional[PatchGroup]
    def operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem]
    def getBaselineId: ZIO[Any, AwsError, BaselineId] =
      AwsError.unwrapOptionField("baselineId", baselineId)
    def getPatchGroup: ZIO[Any, AwsError, PatchGroup] =
      AwsError.unwrapOptionField("patchGroup", patchGroup)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.ssm.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse
  ) extends zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse.ReadOnly {
    override val baselineId: Optional[BaselineId] = zio.aws.core.internal
      .optionalFromNullable(impl.baselineId())
      .map(value => zio.aws.ssm.model.primitives.BaselineId(value))
    override val patchGroup: Optional[PatchGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.patchGroup())
      .map(value => zio.aws.ssm.model.primitives.PatchGroup(value))
    override val operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.ssm.model.OperatingSystem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse
  ): zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse.ReadOnly =
    new Wrapper(impl)
}
