package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait AssociationExecutionTargetsFilterKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey
}
object AssociationExecutionTargetsFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey
  ): zio.aws.ssm.model.AssociationExecutionTargetsFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey.STATUS =>
      val r = Status
      r
    case software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey.RESOURCE_ID =>
      val r = ResourceId
      r
    case software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey.RESOURCE_TYPE =>
      val r = ResourceType
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.AssociationExecutionTargetsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Status
      extends zio.aws.ssm.model.AssociationExecutionTargetsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey.STATUS
  }
  case object ResourceId
      extends zio.aws.ssm.model.AssociationExecutionTargetsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey.RESOURCE_ID
  }
  case object ResourceType
      extends zio.aws.ssm.model.AssociationExecutionTargetsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey =
      software.amazon.awssdk.services.ssm.model.AssociationExecutionTargetsFilterKey.RESOURCE_TYPE
  }
}
