package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, AttributeValue, AttributeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePatchPropertiesResponse(
    properties: Optional[Iterable[Map[AttributeName, AttributeValue]]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse = {
    import DescribePatchPropertiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse
      .builder()
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                  .unwrap(value): java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.properties)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchPropertiesResponse.ReadOnly =
    zio.aws.ssm.model.DescribePatchPropertiesResponse.wrap(buildAwsValue())
}
object DescribePatchPropertiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchPropertiesResponse =
      zio.aws.ssm.model.DescribePatchPropertiesResponse(
        properties.map(value => value),
        nextToken.map(value => value)
      )
    def properties: Optional[List[Map[AttributeName, AttributeValue]]]
    def nextToken: Optional[NextToken]
    def getProperties
        : ZIO[Any, AwsError, List[Map[AttributeName, AttributeValue]]] =
      AwsError.unwrapOptionField("properties", properties)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse
  ) extends zio.aws.ssm.model.DescribePatchPropertiesResponse.ReadOnly {
    override val properties
        : Optional[List[Map[AttributeName, AttributeValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.ssm.model.primitives.AttributeName(
                  key
                ) -> zio.aws.ssm.model.primitives.AttributeValue(value)
              })
              .toMap
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse
  ): zio.aws.ssm.model.DescribePatchPropertiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
