package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AssociationExecutionFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociationExecutionFilter(
    key: zio.aws.ssm.model.AssociationExecutionFilterKey,
    value: AssociationExecutionFilterValue,
    `type`: zio.aws.ssm.model.AssociationFilterOperatorType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationExecutionFilter = {
    import AssociationExecutionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationExecutionFilter
      .builder()
      .key(key.unwrap)
      .value(AssociationExecutionFilterValue.unwrap(value): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationExecutionFilter.ReadOnly =
    zio.aws.ssm.model.AssociationExecutionFilter.wrap(buildAwsValue())
}
object AssociationExecutionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationExecutionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationExecutionFilter =
      zio.aws.ssm.model.AssociationExecutionFilter(key, value, `type`)
    def key: zio.aws.ssm.model.AssociationExecutionFilterKey
    def value: AssociationExecutionFilterValue
    def `type`: zio.aws.ssm.model.AssociationFilterOperatorType
    def getKey
        : ZIO[Any, Nothing, zio.aws.ssm.model.AssociationExecutionFilterKey] =
      ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, AssociationExecutionFilterValue] =
      ZIO.succeed(value)
    def getType
        : ZIO[Any, Nothing, zio.aws.ssm.model.AssociationFilterOperatorType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecutionFilter
  ) extends zio.aws.ssm.model.AssociationExecutionFilter.ReadOnly {
    override val key: zio.aws.ssm.model.AssociationExecutionFilterKey =
      zio.aws.ssm.model.AssociationExecutionFilterKey.wrap(impl.key())
    override val value: AssociationExecutionFilterValue =
      zio.aws.ssm.model.primitives.AssociationExecutionFilterValue(impl.value())
    override val `type`: zio.aws.ssm.model.AssociationFilterOperatorType =
      zio.aws.ssm.model.AssociationFilterOperatorType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecutionFilter
  ): zio.aws.ssm.model.AssociationExecutionFilter.ReadOnly = new Wrapper(impl)
}
