package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RelatedOpsItem(opsItemId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RelatedOpsItem = {
    import RelatedOpsItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RelatedOpsItem
      .builder()
      .opsItemId(opsItemId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.RelatedOpsItem.ReadOnly =
    zio.aws.ssm.model.RelatedOpsItem.wrap(buildAwsValue())
}
object RelatedOpsItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RelatedOpsItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.RelatedOpsItem =
      zio.aws.ssm.model.RelatedOpsItem(opsItemId)
    def opsItemId: String
    def getOpsItemId: ZIO[Any, Nothing, String] = ZIO.succeed(opsItemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RelatedOpsItem
  ) extends zio.aws.ssm.model.RelatedOpsItem.ReadOnly {
    override val opsItemId: String = impl.opsItemId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RelatedOpsItem
  ): zio.aws.ssm.model.RelatedOpsItem.ReadOnly = new Wrapper(impl)
}
