package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  PatchKbNumber,
  PatchArch,
  PatchName,
  PatchVersion,
  PatchRelease,
  PatchDescription,
  PatchAdvisoryId,
  PatchMsrcSeverity,
  PatchEpoch,
  PatchContentUrl,
  DateTime,
  PatchProductFamily,
  PatchRepository,
  PatchProduct,
  PatchId,
  PatchCVEId,
  PatchLanguage,
  PatchVendor,
  PatchMsrcNumber,
  PatchBugzillaId,
  PatchSeverity,
  PatchTitle,
  PatchClassification
}
import scala.jdk.CollectionConverters._
final case class Patch(
    id: Optional[PatchId] = Optional.Absent,
    releaseDate: Optional[DateTime] = Optional.Absent,
    title: Optional[PatchTitle] = Optional.Absent,
    description: Optional[PatchDescription] = Optional.Absent,
    contentUrl: Optional[PatchContentUrl] = Optional.Absent,
    vendor: Optional[PatchVendor] = Optional.Absent,
    productFamily: Optional[PatchProductFamily] = Optional.Absent,
    product: Optional[PatchProduct] = Optional.Absent,
    classification: Optional[PatchClassification] = Optional.Absent,
    msrcSeverity: Optional[PatchMsrcSeverity] = Optional.Absent,
    kbNumber: Optional[PatchKbNumber] = Optional.Absent,
    msrcNumber: Optional[PatchMsrcNumber] = Optional.Absent,
    language: Optional[PatchLanguage] = Optional.Absent,
    advisoryIds: Optional[Iterable[PatchAdvisoryId]] = Optional.Absent,
    bugzillaIds: Optional[Iterable[PatchBugzillaId]] = Optional.Absent,
    cveIds: Optional[Iterable[PatchCVEId]] = Optional.Absent,
    name: Optional[PatchName] = Optional.Absent,
    epoch: Optional[PatchEpoch] = Optional.Absent,
    version: Optional[PatchVersion] = Optional.Absent,
    release: Optional[PatchRelease] = Optional.Absent,
    arch: Optional[PatchArch] = Optional.Absent,
    severity: Optional[PatchSeverity] = Optional.Absent,
    repository: Optional[PatchRepository] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Patch = {
    import Patch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Patch
      .builder()
      .optionallyWith(id.map(value => PatchId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        releaseDate.map(value => DateTime.unwrap(value): Instant)
      )(_.releaseDate)
      .optionallyWith(
        title.map(value => PatchTitle.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        description.map(value =>
          PatchDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        contentUrl.map(value => PatchContentUrl.unwrap(value): java.lang.String)
      )(_.contentUrl)
      .optionallyWith(
        vendor.map(value => PatchVendor.unwrap(value): java.lang.String)
      )(_.vendor)
      .optionallyWith(
        productFamily.map(value =>
          PatchProductFamily.unwrap(value): java.lang.String
        )
      )(_.productFamily)
      .optionallyWith(
        product.map(value => PatchProduct.unwrap(value): java.lang.String)
      )(_.product)
      .optionallyWith(
        classification.map(value =>
          PatchClassification.unwrap(value): java.lang.String
        )
      )(_.classification)
      .optionallyWith(
        msrcSeverity.map(value =>
          PatchMsrcSeverity.unwrap(value): java.lang.String
        )
      )(_.msrcSeverity)
      .optionallyWith(
        kbNumber.map(value => PatchKbNumber.unwrap(value): java.lang.String)
      )(_.kbNumber)
      .optionallyWith(
        msrcNumber.map(value => PatchMsrcNumber.unwrap(value): java.lang.String)
      )(_.msrcNumber)
      .optionallyWith(
        language.map(value => PatchLanguage.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        advisoryIds.map(value =>
          value.map { item =>
            PatchAdvisoryId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.advisoryIds)
      .optionallyWith(
        bugzillaIds.map(value =>
          value.map { item =>
            PatchBugzillaId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bugzillaIds)
      .optionallyWith(
        cveIds.map(value =>
          value.map { item =>
            PatchCVEId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.cveIds)
      .optionallyWith(
        name.map(value => PatchName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(epoch.map(value => PatchEpoch.unwrap(value): Integer))(
        _.epoch
      )
      .optionallyWith(
        version.map(value => PatchVersion.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        release.map(value => PatchRelease.unwrap(value): java.lang.String)
      )(_.release)
      .optionallyWith(
        arch.map(value => PatchArch.unwrap(value): java.lang.String)
      )(_.arch)
      .optionallyWith(
        severity.map(value => PatchSeverity.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(
        repository.map(value => PatchRepository.unwrap(value): java.lang.String)
      )(_.repository)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Patch.ReadOnly =
    zio.aws.ssm.model.Patch.wrap(buildAwsValue())
}
object Patch {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Patch] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Patch = zio.aws.ssm.model.Patch(
      id.map(value => value),
      releaseDate.map(value => value),
      title.map(value => value),
      description.map(value => value),
      contentUrl.map(value => value),
      vendor.map(value => value),
      productFamily.map(value => value),
      product.map(value => value),
      classification.map(value => value),
      msrcSeverity.map(value => value),
      kbNumber.map(value => value),
      msrcNumber.map(value => value),
      language.map(value => value),
      advisoryIds.map(value => value),
      bugzillaIds.map(value => value),
      cveIds.map(value => value),
      name.map(value => value),
      epoch.map(value => value),
      version.map(value => value),
      release.map(value => value),
      arch.map(value => value),
      severity.map(value => value),
      repository.map(value => value)
    )
    def id: Optional[PatchId]
    def releaseDate: Optional[DateTime]
    def title: Optional[PatchTitle]
    def description: Optional[PatchDescription]
    def contentUrl: Optional[PatchContentUrl]
    def vendor: Optional[PatchVendor]
    def productFamily: Optional[PatchProductFamily]
    def product: Optional[PatchProduct]
    def classification: Optional[PatchClassification]
    def msrcSeverity: Optional[PatchMsrcSeverity]
    def kbNumber: Optional[PatchKbNumber]
    def msrcNumber: Optional[PatchMsrcNumber]
    def language: Optional[PatchLanguage]
    def advisoryIds: Optional[List[PatchAdvisoryId]]
    def bugzillaIds: Optional[List[PatchBugzillaId]]
    def cveIds: Optional[List[PatchCVEId]]
    def name: Optional[PatchName]
    def epoch: Optional[PatchEpoch]
    def version: Optional[PatchVersion]
    def release: Optional[PatchRelease]
    def arch: Optional[PatchArch]
    def severity: Optional[PatchSeverity]
    def repository: Optional[PatchRepository]
    def getId: ZIO[Any, AwsError, PatchId] =
      AwsError.unwrapOptionField("id", id)
    def getReleaseDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("releaseDate", releaseDate)
    def getTitle: ZIO[Any, AwsError, PatchTitle] =
      AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, PatchDescription] =
      AwsError.unwrapOptionField("description", description)
    def getContentUrl: ZIO[Any, AwsError, PatchContentUrl] =
      AwsError.unwrapOptionField("contentUrl", contentUrl)
    def getVendor: ZIO[Any, AwsError, PatchVendor] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getProductFamily: ZIO[Any, AwsError, PatchProductFamily] =
      AwsError.unwrapOptionField("productFamily", productFamily)
    def getProduct: ZIO[Any, AwsError, PatchProduct] =
      AwsError.unwrapOptionField("product", product)
    def getClassification: ZIO[Any, AwsError, PatchClassification] =
      AwsError.unwrapOptionField("classification", classification)
    def getMsrcSeverity: ZIO[Any, AwsError, PatchMsrcSeverity] =
      AwsError.unwrapOptionField("msrcSeverity", msrcSeverity)
    def getKbNumber: ZIO[Any, AwsError, PatchKbNumber] =
      AwsError.unwrapOptionField("kbNumber", kbNumber)
    def getMsrcNumber: ZIO[Any, AwsError, PatchMsrcNumber] =
      AwsError.unwrapOptionField("msrcNumber", msrcNumber)
    def getLanguage: ZIO[Any, AwsError, PatchLanguage] =
      AwsError.unwrapOptionField("language", language)
    def getAdvisoryIds: ZIO[Any, AwsError, List[PatchAdvisoryId]] =
      AwsError.unwrapOptionField("advisoryIds", advisoryIds)
    def getBugzillaIds: ZIO[Any, AwsError, List[PatchBugzillaId]] =
      AwsError.unwrapOptionField("bugzillaIds", bugzillaIds)
    def getCveIds: ZIO[Any, AwsError, List[PatchCVEId]] =
      AwsError.unwrapOptionField("cveIds", cveIds)
    def getName: ZIO[Any, AwsError, PatchName] =
      AwsError.unwrapOptionField("name", name)
    def getEpoch: ZIO[Any, AwsError, PatchEpoch] =
      AwsError.unwrapOptionField("epoch", epoch)
    def getVersion: ZIO[Any, AwsError, PatchVersion] =
      AwsError.unwrapOptionField("version", version)
    def getRelease: ZIO[Any, AwsError, PatchRelease] =
      AwsError.unwrapOptionField("release", release)
    def getArch: ZIO[Any, AwsError, PatchArch] =
      AwsError.unwrapOptionField("arch", arch)
    def getSeverity: ZIO[Any, AwsError, PatchSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getRepository: ZIO[Any, AwsError, PatchRepository] =
      AwsError.unwrapOptionField("repository", repository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Patch
  ) extends zio.aws.ssm.model.Patch.ReadOnly {
    override val id: Optional[PatchId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.ssm.model.primitives.PatchId(value))
    override val releaseDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val title: Optional[PatchTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.ssm.model.primitives.PatchTitle(value))
    override val description: Optional[PatchDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.ssm.model.primitives.PatchDescription(value))
    override val contentUrl: Optional[PatchContentUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.contentUrl())
      .map(value => zio.aws.ssm.model.primitives.PatchContentUrl(value))
    override val vendor: Optional[PatchVendor] = zio.aws.core.internal
      .optionalFromNullable(impl.vendor())
      .map(value => zio.aws.ssm.model.primitives.PatchVendor(value))
    override val productFamily: Optional[PatchProductFamily] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productFamily())
        .map(value => zio.aws.ssm.model.primitives.PatchProductFamily(value))
    override val product: Optional[PatchProduct] = zio.aws.core.internal
      .optionalFromNullable(impl.product())
      .map(value => zio.aws.ssm.model.primitives.PatchProduct(value))
    override val classification: Optional[PatchClassification] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classification())
        .map(value => zio.aws.ssm.model.primitives.PatchClassification(value))
    override val msrcSeverity: Optional[PatchMsrcSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.msrcSeverity())
        .map(value => zio.aws.ssm.model.primitives.PatchMsrcSeverity(value))
    override val kbNumber: Optional[PatchKbNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.kbNumber())
      .map(value => zio.aws.ssm.model.primitives.PatchKbNumber(value))
    override val msrcNumber: Optional[PatchMsrcNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.msrcNumber())
      .map(value => zio.aws.ssm.model.primitives.PatchMsrcNumber(value))
    override val language: Optional[PatchLanguage] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.ssm.model.primitives.PatchLanguage(value))
    override val advisoryIds: Optional[List[PatchAdvisoryId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advisoryIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PatchAdvisoryId(item)
          }.toList
        )
    override val bugzillaIds: Optional[List[PatchBugzillaId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bugzillaIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PatchBugzillaId(item)
          }.toList
        )
    override val cveIds: Optional[List[PatchCVEId]] = zio.aws.core.internal
      .optionalFromNullable(impl.cveIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.PatchCVEId(item)
        }.toList
      )
    override val name: Optional[PatchName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.PatchName(value))
    override val epoch: Optional[PatchEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.epoch())
      .map(value => zio.aws.ssm.model.primitives.PatchEpoch(value))
    override val version: Optional[PatchVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.ssm.model.primitives.PatchVersion(value))
    override val release: Optional[PatchRelease] = zio.aws.core.internal
      .optionalFromNullable(impl.release())
      .map(value => zio.aws.ssm.model.primitives.PatchRelease(value))
    override val arch: Optional[PatchArch] = zio.aws.core.internal
      .optionalFromNullable(impl.arch())
      .map(value => zio.aws.ssm.model.primitives.PatchArch(value))
    override val severity: Optional[PatchSeverity] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => zio.aws.ssm.model.primitives.PatchSeverity(value))
    override val repository: Optional[PatchRepository] = zio.aws.core.internal
      .optionalFromNullable(impl.repository())
      .map(value => zio.aws.ssm.model.primitives.PatchRepository(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Patch
  ): zio.aws.ssm.model.Patch.ReadOnly = new Wrapper(impl)
}
