package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowExecutionId,
  MaintenanceWindowTaskArn,
  DateTime,
  MaintenanceWindowExecutionTaskId,
  MaintenanceWindowExecutionStatusDetails
}
import scala.jdk.CollectionConverters._
final case class MaintenanceWindowExecutionTaskIdentity(
    windowExecutionId: Optional[MaintenanceWindowExecutionId] = Optional.Absent,
    taskExecutionId: Optional[MaintenanceWindowExecutionTaskId] =
      Optional.Absent,
    status: Optional[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] =
      Optional.Absent,
    statusDetails: Optional[MaintenanceWindowExecutionStatusDetails] =
      Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    endTime: Optional[DateTime] = Optional.Absent,
    taskArn: Optional[MaintenanceWindowTaskArn] = Optional.Absent,
    taskType: Optional[zio.aws.ssm.model.MaintenanceWindowTaskType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity = {
    import MaintenanceWindowExecutionTaskIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity
      .builder()
      .optionallyWith(
        windowExecutionId.map(value =>
          MaintenanceWindowExecutionId.unwrap(value): java.lang.String
        )
      )(_.windowExecutionId)
      .optionallyWith(
        taskExecutionId.map(value =>
          MaintenanceWindowExecutionTaskId.unwrap(value): java.lang.String
        )
      )(_.taskExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          MaintenanceWindowExecutionStatusDetails.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        taskArn.map(value =>
          MaintenanceWindowTaskArn.unwrap(value): java.lang.String
        )
      )(_.taskArn)
      .optionallyWith(taskType.map(value => value.unwrap))(_.taskType)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity
      .wrap(buildAwsValue())
}
object MaintenanceWindowExecutionTaskIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity =
      zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity(
        windowExecutionId.map(value => value),
        taskExecutionId.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        taskArn.map(value => value),
        taskType.map(value => value)
      )
    def windowExecutionId: Optional[MaintenanceWindowExecutionId]
    def taskExecutionId: Optional[MaintenanceWindowExecutionTaskId]
    def status: Optional[zio.aws.ssm.model.MaintenanceWindowExecutionStatus]
    def statusDetails: Optional[MaintenanceWindowExecutionStatusDetails]
    def startTime: Optional[DateTime]
    def endTime: Optional[DateTime]
    def taskArn: Optional[MaintenanceWindowTaskArn]
    def taskType: Optional[zio.aws.ssm.model.MaintenanceWindowTaskType]
    def getWindowExecutionId: ZIO[Any, AwsError, MaintenanceWindowExecutionId] =
      AwsError.unwrapOptionField("windowExecutionId", windowExecutionId)
    def getTaskExecutionId
        : ZIO[Any, AwsError, MaintenanceWindowExecutionTaskId] =
      AwsError.unwrapOptionField("taskExecutionId", taskExecutionId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails
        : ZIO[Any, AwsError, MaintenanceWindowExecutionStatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getTaskArn: ZIO[Any, AwsError, MaintenanceWindowTaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getTaskType
        : ZIO[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowTaskType] =
      AwsError.unwrapOptionField("taskType", taskType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity
  ) extends zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly {
    override val windowExecutionId: Optional[MaintenanceWindowExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowExecutionId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId(value)
        )
    override val taskExecutionId: Optional[MaintenanceWindowExecutionTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskExecutionId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowExecutionTaskId(value)
        )
    override val status
        : Optional[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.ssm.model.MaintenanceWindowExecutionStatus.wrap(value)
        )
    override val statusDetails
        : Optional[MaintenanceWindowExecutionStatusDetails] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDetails())
        .map(value =>
          zio.aws.ssm.model.primitives
            .MaintenanceWindowExecutionStatusDetails(value)
        )
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val endTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val taskArn: Optional[MaintenanceWindowTaskArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskArn())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTaskArn(value)
        )
    override val taskType
        : Optional[zio.aws.ssm.model.MaintenanceWindowTaskType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskType())
        .map(value => zio.aws.ssm.model.MaintenanceWindowTaskType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity
  ): zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly =
    new Wrapper(impl)
}
