package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{NextToken, ListOpsMetadataMaxResults}
import scala.jdk.CollectionConverters._
final case class ListOpsMetadataRequest(
    filters: Optional[Iterable[zio.aws.ssm.model.OpsMetadataFilter]] =
      Optional.Absent,
    maxResults: Optional[ListOpsMetadataMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest = {
    import ListOpsMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          ListOpsMetadataMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListOpsMetadataRequest.ReadOnly =
    zio.aws.ssm.model.ListOpsMetadataRequest.wrap(buildAwsValue())
}
object ListOpsMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListOpsMetadataRequest =
      zio.aws.ssm.model.ListOpsMetadataRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[List[zio.aws.ssm.model.OpsMetadataFilter.ReadOnly]]
    def maxResults: Optional[ListOpsMetadataMaxResults]
    def nextToken: Optional[NextToken]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsMetadataFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, ListOpsMetadataMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest
  ) extends zio.aws.ssm.model.ListOpsMetadataRequest.ReadOnly {
    override val filters
        : Optional[List[zio.aws.ssm.model.OpsMetadataFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsMetadataFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[ListOpsMetadataMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.ListOpsMetadataMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest
  ): zio.aws.ssm.model.ListOpsMetadataRequest.ReadOnly = new Wrapper(impl)
}
