package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsMetadataArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateOpsMetadataResponse(
    opsMetadataArn: Optional[OpsMetadataArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateOpsMetadataResponse = {
    import CreateOpsMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateOpsMetadataResponse
      .builder()
      .optionallyWith(
        opsMetadataArn.map(value =>
          OpsMetadataArn.unwrap(value): java.lang.String
        )
      )(_.opsMetadataArn)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateOpsMetadataResponse.ReadOnly =
    zio.aws.ssm.model.CreateOpsMetadataResponse.wrap(buildAwsValue())
}
object CreateOpsMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateOpsMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateOpsMetadataResponse =
      zio.aws.ssm.model
        .CreateOpsMetadataResponse(opsMetadataArn.map(value => value))
    def opsMetadataArn: Optional[OpsMetadataArn]
    def getOpsMetadataArn: ZIO[Any, AwsError, OpsMetadataArn] =
      AwsError.unwrapOptionField("opsMetadataArn", opsMetadataArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateOpsMetadataResponse
  ) extends zio.aws.ssm.model.CreateOpsMetadataResponse.ReadOnly {
    override val opsMetadataArn: Optional[OpsMetadataArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.opsMetadataArn())
        .map(value => zio.aws.ssm.model.primitives.OpsMetadataArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateOpsMetadataResponse
  ): zio.aws.ssm.model.CreateOpsMetadataResponse.ReadOnly = new Wrapper(impl)
}
