package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait LastResourceDataSyncStatus {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus
}
object LastResourceDataSyncStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus
  ): zio.aws.ssm.model.LastResourceDataSyncStatus = value match {
    case software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus.SUCCESSFUL =>
      val r = Successful
      r
    case software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus.IN_PROGRESS =>
      val r = InProgress
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.LastResourceDataSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus =
      software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Successful extends zio.aws.ssm.model.LastResourceDataSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus =
      software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus.SUCCESSFUL
  }
  case object Failed extends zio.aws.ssm.model.LastResourceDataSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus =
      software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus.FAILED
  }
  case object InProgress extends zio.aws.ssm.model.LastResourceDataSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus =
      software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus.IN_PROGRESS
  }
}
