package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AttributeName,
  InventoryItemSchemaVersion,
  InventoryItemCaptureTime,
  InventoryItemTypeName,
  InventoryItemContentHash,
  AttributeValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InventoryResultItem(
    typeName: InventoryItemTypeName,
    schemaVersion: InventoryItemSchemaVersion,
    captureTime: Optional[InventoryItemCaptureTime] = Optional.Absent,
    contentHash: Optional[InventoryItemContentHash] = Optional.Absent,
    content: Iterable[Map[AttributeName, AttributeValue]]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryResultItem = {
    import InventoryResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryResultItem
      .builder()
      .typeName(InventoryItemTypeName.unwrap(typeName): java.lang.String)
      .schemaVersion(
        InventoryItemSchemaVersion.unwrap(schemaVersion): java.lang.String
      )
      .optionallyWith(
        captureTime.map(value =>
          InventoryItemCaptureTime.unwrap(value): java.lang.String
        )
      )(_.captureTime)
      .optionallyWith(
        contentHash.map(value =>
          InventoryItemContentHash.unwrap(value): java.lang.String
        )
      )(_.contentHash)
      .content(content.map { item =>
        item
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryResultItem.ReadOnly =
    zio.aws.ssm.model.InventoryResultItem.wrap(buildAwsValue())
}
object InventoryResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryResultItem =
      zio.aws.ssm.model.InventoryResultItem(
        typeName,
        schemaVersion,
        captureTime.map(value => value),
        contentHash.map(value => value),
        content
      )
    def typeName: InventoryItemTypeName
    def schemaVersion: InventoryItemSchemaVersion
    def captureTime: Optional[InventoryItemCaptureTime]
    def contentHash: Optional[InventoryItemContentHash]
    def content: List[Map[AttributeName, AttributeValue]]
    def getTypeName: ZIO[Any, Nothing, InventoryItemTypeName] =
      ZIO.succeed(typeName)
    def getSchemaVersion: ZIO[Any, Nothing, InventoryItemSchemaVersion] =
      ZIO.succeed(schemaVersion)
    def getCaptureTime: ZIO[Any, AwsError, InventoryItemCaptureTime] =
      AwsError.unwrapOptionField("captureTime", captureTime)
    def getContentHash: ZIO[Any, AwsError, InventoryItemContentHash] =
      AwsError.unwrapOptionField("contentHash", contentHash)
    def getContent
        : ZIO[Any, Nothing, List[Map[AttributeName, AttributeValue]]] =
      ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryResultItem
  ) extends zio.aws.ssm.model.InventoryResultItem.ReadOnly {
    override val typeName: InventoryItemTypeName =
      zio.aws.ssm.model.primitives.InventoryItemTypeName(impl.typeName())
    override val schemaVersion: InventoryItemSchemaVersion =
      zio.aws.ssm.model.primitives
        .InventoryItemSchemaVersion(impl.schemaVersion())
    override val captureTime: Optional[InventoryItemCaptureTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captureTime())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryItemCaptureTime(value)
        )
    override val contentHash: Optional[InventoryItemContentHash] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentHash())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryItemContentHash(value)
        )
    override val content: List[Map[AttributeName, AttributeValue]] = impl
      .content()
      .asScala
      .map { item =>
        item.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.AttributeName(
              key
            ) -> zio.aws.ssm.model.primitives.AttributeValue(value)
          })
          .toMap
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryResultItem
  ): zio.aws.ssm.model.InventoryResultItem.ReadOnly = new Wrapper(impl)
}
