package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  OpsItemRelatedItemAssociationResourceUri,
  OpsItemRelatedItemAssociationResourceType,
  OpsItemRelatedItemAssociationType,
  OpsItemId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateOpsItemRelatedItemRequest(
    opsItemId: OpsItemId,
    associationType: OpsItemRelatedItemAssociationType,
    resourceType: OpsItemRelatedItemAssociationResourceType,
    resourceUri: OpsItemRelatedItemAssociationResourceUri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemRequest = {
    import AssociateOpsItemRelatedItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemRequest
      .builder()
      .opsItemId(OpsItemId.unwrap(opsItemId): java.lang.String)
      .associationType(
        OpsItemRelatedItemAssociationType.unwrap(
          associationType
        ): java.lang.String
      )
      .resourceType(
        OpsItemRelatedItemAssociationResourceType.unwrap(
          resourceType
        ): java.lang.String
      )
      .resourceUri(
        OpsItemRelatedItemAssociationResourceUri.unwrap(
          resourceUri
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.AssociateOpsItemRelatedItemRequest.ReadOnly =
    zio.aws.ssm.model.AssociateOpsItemRelatedItemRequest.wrap(buildAwsValue())
}
object AssociateOpsItemRelatedItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociateOpsItemRelatedItemRequest =
      zio.aws.ssm.model.AssociateOpsItemRelatedItemRequest(
        opsItemId,
        associationType,
        resourceType,
        resourceUri
      )
    def opsItemId: OpsItemId
    def associationType: OpsItemRelatedItemAssociationType
    def resourceType: OpsItemRelatedItemAssociationResourceType
    def resourceUri: OpsItemRelatedItemAssociationResourceUri
    def getOpsItemId: ZIO[Any, Nothing, OpsItemId] = ZIO.succeed(opsItemId)
    def getAssociationType
        : ZIO[Any, Nothing, OpsItemRelatedItemAssociationType] =
      ZIO.succeed(associationType)
    def getResourceType
        : ZIO[Any, Nothing, OpsItemRelatedItemAssociationResourceType] =
      ZIO.succeed(resourceType)
    def getResourceUri
        : ZIO[Any, Nothing, OpsItemRelatedItemAssociationResourceUri] =
      ZIO.succeed(resourceUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemRequest
  ) extends zio.aws.ssm.model.AssociateOpsItemRelatedItemRequest.ReadOnly {
    override val opsItemId: OpsItemId =
      zio.aws.ssm.model.primitives.OpsItemId(impl.opsItemId())
    override val associationType: OpsItemRelatedItemAssociationType =
      zio.aws.ssm.model.primitives
        .OpsItemRelatedItemAssociationType(impl.associationType())
    override val resourceType: OpsItemRelatedItemAssociationResourceType =
      zio.aws.ssm.model.primitives
        .OpsItemRelatedItemAssociationResourceType(impl.resourceType())
    override val resourceUri: OpsItemRelatedItemAssociationResourceUri =
      zio.aws.ssm.model.primitives
        .OpsItemRelatedItemAssociationResourceUri(impl.resourceUri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemRequest
  ): zio.aws.ssm.model.AssociateOpsItemRelatedItemRequest.ReadOnly =
    new Wrapper(impl)
}
