package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ParametersFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ParametersFilter(
    key: zio.aws.ssm.model.ParametersFilterKey,
    values: Iterable[ParametersFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ParametersFilter = {
    import ParametersFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ParametersFilter
      .builder()
      .key(key.unwrap)
      .values(values.map { item =>
        ParametersFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ParametersFilter.ReadOnly =
    zio.aws.ssm.model.ParametersFilter.wrap(buildAwsValue())
}
object ParametersFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ParametersFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ParametersFilter =
      zio.aws.ssm.model.ParametersFilter(key, values)
    def key: zio.aws.ssm.model.ParametersFilterKey
    def values: List[ParametersFilterValue]
    def getKey: ZIO[Any, Nothing, zio.aws.ssm.model.ParametersFilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[ParametersFilterValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ParametersFilter
  ) extends zio.aws.ssm.model.ParametersFilter.ReadOnly {
    override val key: zio.aws.ssm.model.ParametersFilterKey =
      zio.aws.ssm.model.ParametersFilterKey.wrap(impl.key())
    override val values: List[ParametersFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.ParametersFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ParametersFilter
  ): zio.aws.ssm.model.ParametersFilter.ReadOnly = new Wrapper(impl)
}
