package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  RemainingCount,
  ResourceCount,
  InventoryItemSchemaVersion
}
import scala.jdk.CollectionConverters._
final case class InventoryDeletionSummaryItem(
    version: Optional[InventoryItemSchemaVersion] = Optional.Absent,
    count: Optional[ResourceCount] = Optional.Absent,
    remainingCount: Optional[RemainingCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem = {
    import InventoryDeletionSummaryItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem
      .builder()
      .optionallyWith(
        version.map(value =>
          InventoryItemSchemaVersion.unwrap(value): java.lang.String
        )
      )(_.version)
      .optionallyWith(count.map(value => ResourceCount.unwrap(value): Integer))(
        _.count
      )
      .optionallyWith(
        remainingCount.map(value => RemainingCount.unwrap(value): Integer)
      )(_.remainingCount)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryDeletionSummaryItem.ReadOnly =
    zio.aws.ssm.model.InventoryDeletionSummaryItem.wrap(buildAwsValue())
}
object InventoryDeletionSummaryItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryDeletionSummaryItem =
      zio.aws.ssm.model.InventoryDeletionSummaryItem(
        version.map(value => value),
        count.map(value => value),
        remainingCount.map(value => value)
      )
    def version: Optional[InventoryItemSchemaVersion]
    def count: Optional[ResourceCount]
    def remainingCount: Optional[RemainingCount]
    def getVersion: ZIO[Any, AwsError, InventoryItemSchemaVersion] =
      AwsError.unwrapOptionField("version", version)
    def getCount: ZIO[Any, AwsError, ResourceCount] =
      AwsError.unwrapOptionField("count", count)
    def getRemainingCount: ZIO[Any, AwsError, RemainingCount] =
      AwsError.unwrapOptionField("remainingCount", remainingCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem
  ) extends zio.aws.ssm.model.InventoryDeletionSummaryItem.ReadOnly {
    override val version: Optional[InventoryItemSchemaVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.version())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryItemSchemaVersion(value)
        )
    override val count: Optional[ResourceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.ssm.model.primitives.ResourceCount(value))
    override val remainingCount: Optional[RemainingCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remainingCount())
        .map(value => zio.aws.ssm.model.primitives.RemainingCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem
  ): zio.aws.ssm.model.InventoryDeletionSummaryItem.ReadOnly = new Wrapper(impl)
}
