package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{ResourceDataSyncType, ResourceDataSyncName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateResourceDataSyncRequest(
    syncName: ResourceDataSyncName,
    syncType: ResourceDataSyncType,
    syncSource: zio.aws.ssm.model.ResourceDataSyncSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncRequest = {
    import UpdateResourceDataSyncRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncRequest
      .builder()
      .syncName(ResourceDataSyncName.unwrap(syncName): java.lang.String)
      .syncType(ResourceDataSyncType.unwrap(syncType): java.lang.String)
      .syncSource(syncSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateResourceDataSyncRequest.ReadOnly =
    zio.aws.ssm.model.UpdateResourceDataSyncRequest.wrap(buildAwsValue())
}
object UpdateResourceDataSyncRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateResourceDataSyncRequest =
      zio.aws.ssm.model.UpdateResourceDataSyncRequest(
        syncName,
        syncType,
        syncSource.asEditable
      )
    def syncName: ResourceDataSyncName
    def syncType: ResourceDataSyncType
    def syncSource: zio.aws.ssm.model.ResourceDataSyncSource.ReadOnly
    def getSyncName: ZIO[Any, Nothing, ResourceDataSyncName] =
      ZIO.succeed(syncName)
    def getSyncType: ZIO[Any, Nothing, ResourceDataSyncType] =
      ZIO.succeed(syncType)
    def getSyncSource
        : ZIO[Any, Nothing, zio.aws.ssm.model.ResourceDataSyncSource.ReadOnly] =
      ZIO.succeed(syncSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncRequest
  ) extends zio.aws.ssm.model.UpdateResourceDataSyncRequest.ReadOnly {
    override val syncName: ResourceDataSyncName =
      zio.aws.ssm.model.primitives.ResourceDataSyncName(impl.syncName())
    override val syncType: ResourceDataSyncType =
      zio.aws.ssm.model.primitives.ResourceDataSyncType(impl.syncType())
    override val syncSource: zio.aws.ssm.model.ResourceDataSyncSource.ReadOnly =
      zio.aws.ssm.model.ResourceDataSyncSource.wrap(impl.syncSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncRequest
  ): zio.aws.ssm.model.UpdateResourceDataSyncRequest.ReadOnly = new Wrapper(
    impl
  )
}
