package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  TargetMapValue,
  AutomationParameterValue,
  TargetMapKey,
  DocumentARN,
  DocumentVersion,
  AutomationParameterKey,
  IdempotencyToken,
  MaxConcurrency,
  MaxErrors
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartAutomationExecutionRequest(
    documentName: DocumentARN,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    parameters: Optional[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = Optional.Absent,
    clientToken: Optional[IdempotencyToken] = Optional.Absent,
    mode: Optional[zio.aws.ssm.model.ExecutionMode] = Optional.Absent,
    targetParameterName: Optional[AutomationParameterKey] = Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    targetMaps: Optional[
      Iterable[Map[TargetMapKey, Iterable[TargetMapValue]]]
    ] = Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    maxErrors: Optional[MaxErrors] = Optional.Absent,
    targetLocations: Optional[Iterable[zio.aws.ssm.model.TargetLocation]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ssm.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest = {
    import StartAutomationExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest
      .builder()
      .documentName(DocumentARN.unwrap(documentName): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        targetParameterName.map(value =>
          AutomationParameterKey.unwrap(value): java.lang.String
        )
      )(_.targetParameterName)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        targetMaps.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TargetMapKey.unwrap(key): java.lang.String) -> value.map {
                  item =>
                    TargetMapValue.unwrap(item): java.lang.String
                }.asJavaCollection
              })
              .asJava
          }.asJavaCollection
        )
      )(_.targetMaps)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        targetLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetLocations)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.StartAutomationExecutionRequest.ReadOnly =
    zio.aws.ssm.model.StartAutomationExecutionRequest.wrap(buildAwsValue())
}
object StartAutomationExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StartAutomationExecutionRequest =
      zio.aws.ssm.model.StartAutomationExecutionRequest(
        documentName,
        documentVersion.map(value => value),
        parameters.map(value => value),
        clientToken.map(value => value),
        mode.map(value => value),
        targetParameterName.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetMaps.map(value => value),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        targetLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentName: DocumentARN
    def documentVersion: Optional[DocumentVersion]
    def parameters
        : Optional[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def clientToken: Optional[IdempotencyToken]
    def mode: Optional[zio.aws.ssm.model.ExecutionMode]
    def targetParameterName: Optional[AutomationParameterKey]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def targetMaps: Optional[List[Map[TargetMapKey, List[TargetMapValue]]]]
    def maxConcurrency: Optional[MaxConcurrency]
    def maxErrors: Optional[MaxErrors]
    def targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]]
    def tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def getDocumentName: ZIO[Any, Nothing, DocumentARN] =
      ZIO.succeed(documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getParameters: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMode: ZIO[Any, AwsError, zio.aws.ssm.model.ExecutionMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getTargetParameterName: ZIO[Any, AwsError, AutomationParameterKey] =
      AwsError.unwrapOptionField("targetParameterName", targetParameterName)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTargetMaps
        : ZIO[Any, AwsError, List[Map[TargetMapKey, List[TargetMapValue]]]] =
      AwsError.unwrapOptionField("targetMaps", targetMaps)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getTargetLocations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      AwsError.unwrapOptionField("targetLocations", targetLocations)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest
  ) extends zio.aws.ssm.model.StartAutomationExecutionRequest.ReadOnly {
    override val documentName: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.documentName())
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val parameters: Optional[
      Map[AutomationParameterKey, List[AutomationParameterValue]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives
              .AutomationParameterKey(key) -> value.asScala.map { item =>
              zio.aws.ssm.model.primitives.AutomationParameterValue(item)
            }.toList
          })
          .toMap
      )
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.ssm.model.primitives.IdempotencyToken(value))
    override val mode: Optional[zio.aws.ssm.model.ExecutionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.ssm.model.ExecutionMode.wrap(value))
    override val targetParameterName: Optional[AutomationParameterKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetParameterName())
        .map(value =>
          zio.aws.ssm.model.primitives.AutomationParameterKey(value)
        )
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val targetMaps
        : Optional[List[Map[TargetMapKey, List[TargetMapValue]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetMaps())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.ssm.model.primitives
                  .TargetMapKey(key) -> value.asScala.map { item =>
                  zio.aws.ssm.model.primitives.TargetMapValue(item)
                }.toList
              })
              .toMap
          }.toList
        )
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.TargetLocation.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest
  ): zio.aws.ssm.model.StartAutomationExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
